
//
// To jest przykadowy kod z podrozdziau 19.5.4 Obiekt auto_ptr ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <memory>
#include <stdexcept>
#include <vector>

using std::auto_ptr;
using std::vector;

//------------------------------------------------------------------------------

vector<int>* make_vec()    // Tworzy peny wektor.
{
    auto_ptr< vector<int> > p(new vector<int>); // Alokacja w pamici wolnej.
    // Napenia wektor danymi. Tu moe zosta zgoszony wyjtek.
    return p.release(); // Zwraca wskanik przechowywany przez p.
}

//------------------------------------------------------------------------------

int main()
try
{
    auto_ptr< vector<int> > p(make_vec());
}
catch (std::exception& e) {
    std::cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    std::cerr << "Ojej: nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
